function param = getstyleparam(stylesetting)
% 
if nargin ==0
    stylesetting = 'standard';
end

fig = figure('Visible','off'); %for doodleing

switch lower(stylesetting)
    case 'poreviewer'
        param = getstyleparam('standard');
        % Add alterations here
        param.info_table.style.Units = 'pixels';
        
        param.info_table.sizing.htype = 'Fixed';
        param.info_table.sizing.h = 20;
        param.info_table.sizing.wtype = 'Fixed';
        param.info_table.sizing.w = 80;
    case 'pore_processing'
        param = getstyleparam('standard');
        % New Stylegroups are:
        % table, rowheading, label, status, fourdigit, 
        % scrolledit, extent_push, binop_push, 
        % Old Stylegroups used are:
        % panel, axes, title, heading, radio, check, filename
        % Edited Stylegroups: 
        % axes
        param.axes.style.Position = [0.05,0.05,.9,.9];
        param.axes.style.ActivePositionProperty = 'position';
        param.axes.AppData.min_ht = 100;
        param.axes.AppData.min_w = 100;
        param.table.style.Units = 'pixels'; % table entries
        param.table.sizing.htype = 'Extent';
        param.table.sizing.wtype = 'Fixed';
        param.table.sizing.w = 80;
        param.rowheading.style.Units = 'pixels'; % row headings in the results table
        param.rowheading.sizing.htype = 'Extent';
        param.rowheading.sizing.wtype = 'Fixed';
        param.rowheading.sizing.w = 80;
        param.label.style.Units = 'pixels'; % text labels
        param.label.sizing.htype = 'Extent';
        param.label.sizing.wtype = 'Extent';
        param.status.style.Units = 'pixels'; % status message text box
        param.status.style.BackgroundColor = [1,1,1]; % white background
        param.status.sizing.htype = 'Extent';
        param.status.sizing.wtype = 'Fixed';
        param.status.sizing.w = 400;
        param.fourdigit.style.Units = 'pixels';
        param.fourdigit.sizing.htype = 'Fixed';
        param.fourdigit.sizing.h = param.edit.sizing.h;
        param.fourdigit.sizing.wtype = 'Fixed';
        param.fourdigit.sizing.w = param.edit.sizing.w;
        param.scrolledit.style.Units = 'pixels';
        param.scrolledit.sizing.htype = 'Fixed';
        param.scrolledit.sizing.h = 3*param.edit.sizing.h;
        param.scrolledit.sizing.wtype = 'Fixed';
        param.scrolledit.sizing.w = 4*param.edit.sizing.w;
        param.extent_push.style = param.button.style;
        param.extent_push.sizing = param.button.sizing;
        param.binop_push.style = param.button.style;
        param.binop_push.sizing.htype = 'ExtentPlus';
        param.binop_push.sizing.hplus = 2;
        param.binop_push.sizing.wtype = 'Fixed';
            h = uipush('Majority'); % longest string
            set(h,param.binop_push.style);
            ext = get(h,'Extent');
            delete(h);
        param.binop_push.sizing.w = ext(3)+5;
        param.check = param.checkbox;
        % adjust filename definition
        param.filename.sizing.w = 3*param.edit.sizing.w;
        
        
        
case 'standard'
    % This is the basic param structure, others are defined relative to
    % this one
    
    % Default StyleGroup categories are:
        % frame, panel, title, heading, text, edit, popup, button, toggle,
        % checkbox, and filename
    
    % Style each category
    param.axes.style.Units = 'normalized';
    param.axes.style.OuterPosition = [0.05,0.05,.9,.9];
    param.axes.style.ActivePositionProperty = 'outerposition';
    
    param.frame.style.Units = 'pixels';

    param.panel.style.Units = 'pixels';
    param.panel.style.FontAngle = 'Italic';
    param.panel.style.FontSize = 14;
    param.panel.style.FontWeight = 'Bold';
    param.panel.style.FontName = 'Times New Roman';
    param.panel.style.TitlePosition = 'centertop';
    
    param.title.style.FontAngle = 'Italic';
    param.title.style.FontSize = 14;
    param.title.style.FontWeight = 'Bold';
    param.title.style.FontName = 'Times New Roman';
    
    param.heading.style.FontName = 'Times New Roman';
    param.heading.style.FontSize = 12;
    param.heading.style.FontWeight = 'Bold';
    param.heading.style.FontAngle = 'Oblique';
    
    param.text.style.FontSize = 12;
    param.text.style.FontName = 'Times';
    
    param.edit.style.FontSize = 12;
    param.edit.style.FontName = 'Times';
    param.edit.style.FontAngle = 'Normal';
    param.edit.style.BackgroundColor = [1,1,1]; 
    param.edit.style.HorizontalAlignment = 'right';
    
    param.popup.style.FontName = 'Times';
    param.popup.style.FontSize = 12;
    param.popup.style.BackgroundColor = [1,1,1];
    
    param.button.style.Units = 'pixels';
    param.button.style.ForegroundColor = [1,0,0];
    
    param.toggle.style.Units = 'pixels';
    param.toggle.style.ForegroundColor = [0,0,1];
    
    param.radio.style.Units = 'pixels';
    
    param.checkbox.style.Units = 'pixels';
    
    param.filename.style = param.edit.style;
    
    % Size each category
    param.axes.sizing.htype = 'none';
    param.axes.sizing.wtype = 'none';
    
    param.panel.sizing.htype = 'none';
    param.panel.sizing.wtype = 'none';
    
    param.title.sizing.htype = 'Extent';
    param.title.sizing.wtype = 'Extent';
    
    param.heading.sizing.htype = 'Extent';
    param.heading.sizing.wtype = 'Extent';
    
    param.text.sizing.htype = 'Extent';
    param.text.sizing.wtype = 'Extent';
    
    param.edit.sizing.htype = 'Fixed';
    param.edit.sizing.wtype = 'Fixed';
    
        %setup for edit height
        dum = uicontrol('Style','Text','String','20.00');
        set(dum,param.edit.style);
        dext = get(dum,'Extent');
        delete(dum);
    param.edit.sizing.h = dext(4)+2; % edit box height should be 2 pixels greater than text
    param.edit.sizing.w = dext(3)+15; % edit box should fit 4 digit number with decimal point
    
    param.popup.sizing.htype = 'Fixed';
    param.popup.sizing.wtype = 'ExtentPlus';
    param.popup.sizing.h = param.edit.sizing.h;
    param.popup.sizing.wplus = 25; % to account for popup arrow;
    
    param.button.sizing.htype = 'ExtentPlus';
    param.button.sizing.wtype = 'ExtentPlus';
    param.button.sizing.wplus = 5;
    param.button.sizing.hplus = 2;
    
    param.toggle.sizing.htype = 'ExtentPlus';
    param.toggle.sizing.wtype = 'ExtentPlus';
    param.toggle.sizing.hplus = 2;
    param.toggle.sizing.wplus = 5;
    
    param.checkbox.sizing.htype = 'Fixed';
    param.checkbox.sizing.wtype = 'Fixed';
    param.checkbox.sizing.h = 15;
    param.checkbox.sizing.w = 15;
    
    param.radio.sizing.htype = 'ExtentPlus';
    param.radio.sizing.wtype = 'ExtentPlus';
    param.radio.sizing.wplus = 15;
    param.radio.sizing.hplus = 2;
    
    % Filename edit boxes should be bigger than number edit boxes
    param.filename.sizing.htype = 'Fixed';
    param.filename.sizing.wtype = 'Fixed';
    param.filename.sizing.h = param.edit.sizing.h; % same height as other edits
    param.filename.sizing.w = 2*param.edit.sizing.w; % double width
    
    % Spacing
    param.spacing.checkboxlift = 6; % this is the amount checkboxes should be lifted to be centered on the line
    
    param.spacing.parent.leftmargin = 4;
    param.spacing.parent.rightmargin = 4;
    param.spacing.parent.topmargin = 4;
    param.spacing.parent.botmargin = 4;
    param.spacing.parent.xstretch = 0;
    param.spacing.parent.ystretch = 0;

    param.spacing.min_interline = 3;
    param.spacing.hdefault = 4;
    param.spacing.default = 4; %default spacing

case 'cellpopsim'
    %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
    %for testing purposes, I'll create a param structure here
    
    % Style each category
    param.frame.style.Units = 'pixels';
    
    param.title.style.FontAngle = 'Italic';
    param.title.style.FontAngle = 'Italic';
    param.title.style.FontSize = 14;
    param.title.style.FontWeight = 'Bold';
    param.title.style.FontName = 'Times New Roman';
    
    param.heading.style.FontName = 'Times New Roman';
    param.heading.style.FontSize = 12;
    param.heading.style.FontWeight = 'Bold';
    param.heading.style.FontAngle = 'Oblique';
    
    param.text.style.FontSize = 12;
    param.text.style.FontName = 'Times';
    
    param.textcw.style.FontSize = 12;
    param.textcw.style.FontName = 'Times';
    
    param.edit.style.FontSize = 10;
    param.edit.style.FontName = 'Times';
    param.edit.style.FontAngle = 'Normal';
    param.edit.style.BackgroundColor = [1,1,1]; 
    param.edit.style.HorizontalAlignment = 'right';
    
    param.popup.style.FontName = 'Times';
    param.popup.style.FontSize = 10;
    param.popup.style.BackgroundColor = [1,1,1];
    
    param.button.style.Units = 'pixels';
    param.button.style.ForegroundColor = [1,0,0];
    
    param.toggle.style.Units = 'pixels';
    param.toggle.style.ForegroundColor = [0,0,1];
    
    param.checkbox.style.Units = 'pixels';
    
    param.filename.style = param.edit.style;
    
    % Size each category
    param.title.sizing.htype = 'Extent';
    param.title.sizing.wtype = 'Extent';
    
    param.heading.sizing.htype = 'Extent';
    param.heading.sizing.wtype = 'Extent';
    
    param.text.sizing.htype = 'Extent';
    param.text.sizing.wtype = 'Extent';
    
    param.textcw.sizing.htype = 'Extent';
    param.textcw.sizing.wtype = 'Fixed';
    param.textcw.sizing.w = 50; % this will need adjusting
    
    param.edit.sizing.htype = 'Fixed';
    param.edit.sizing.wtype = 'Fixed';
    
        %setup for edit height
        dum = uicontrol('Style','Text','String','20.00');
        set(dum,param.edit.style);
        dext = get(dum,'Extent');
        delete(dum);
    param.edit.sizing.h = dext(4)+2; % edit box height should be 4 pixels greater than text
    param.edit.sizing.w = dext(3)+15; % edit box should fit 4 digit number with decimal point
    
    param.popup.sizing.htype = 'Fixed';
    param.popup.sizing.wtype = 'ExtentPlus';
    param.popup.sizing.h = param.edit.sizing.h;
    param.popup.sizing.wplus = 25; % to account for popup arrow;
    
    param.button.sizing.htype = 'ExtentPlus';
    param.button.sizing.wtype = 'ExtentPlus';
    param.button.sizing.wplus = 5;
    param.button.sizing.hplus = 2;
    
    param.toggle.sizing.htype = 'ExtentPlus';
    param.toggle.sizing.wtype = 'ExtentPlus';
    param.toggle.sizing.hplus = 2;
    param.toggle.sizing.wplus = 5;
    
    param.checkbox.sizing.htype = 'Fixed';
    param.checkbox.sizing.wtype = 'Fixed';
    param.checkbox.sizing.h = 15;
    param.checkbox.sizing.w = 15;
    
    % Filename edit boxes should be bigger than number edit boxes
    param.filename.sizing.htype = 'Fixed';
    param.filename.sizing.wtype = 'Fixed';
    param.filename.sizing.h = param.edit.sizing.h; % same height as other edits
    param.filename.sizing.w = 2*param.edit.sizing.w; % double width
    
    % Spacing
    param.spacing.buf = 4; % horizontal pixel buffer spacing...
    param.spacing.min_line_spacing = 4; % this is the spacing above and beyond what is required
    param.spacing.checkboxlift = 6; % this is the amount checkboxes should be lifted to be centered on the line
    
case 'improcgui'    
    % Style each category
    param.frame.style.Units = 'pixels';

    param.panel.style.Units = 'pixels';
    param.panel.style.FontAngle = 'Italic';
    param.panel.style.FontSize = 14;
    param.panel.style.FontWeight = 'Bold';
    param.panel.style.FontName = 'Times New Roman';
    param.panel.style.TitlePosition = 'centertop';
    
    param.title.style.FontAngle = 'Italic';
    param.title.style.FontSize = 14;
    param.title.style.FontWeight = 'Bold';
    param.title.style.FontName = 'Times New Roman';
    
    param.heading.style.FontName = 'Times New Roman';
    param.heading.style.FontSize = 12;
    param.heading.style.FontWeight = 'Bold';
    param.heading.style.FontAngle = 'Oblique';
    
    param.text.style.FontSize = 12;
    param.text.style.FontName = 'Times';
    
    param.status.style.FontName = 'Arial';
    param.status.style.BackgroundColor = [1,1,1];
    
    param.edit.style.FontSize = 12;
    param.edit.style.FontName = 'Times';
    param.edit.style.FontAngle = 'Normal';
    param.edit.style.BackgroundColor = [1,1,1]; 
    param.edit.style.HorizontalAlignment = 'right';
    
    param.popup.style.FontName = 'Times';
    param.popup.style.FontSize = 12;
    param.popup.style.BackgroundColor = [1,1,1];
    
    param.button.style.Units = 'pixels';
    param.button.style.ForegroundColor = [1,0,0];
    
    param.toggle.style.Units = 'pixels';
    param.toggle.style.ForegroundColor = [0,0,1];
    
    param.checkbox.style.Units = 'pixels';
    
    param.filename.style = param.edit.style;
    
    % Size each category
    param.title.sizing.htype = 'Extent';
    param.title.sizing.wtype = 'Extent';
    
    param.heading.sizing.htype = 'Extent';
    param.heading.sizing.wtype = 'Extent';
    
    param.text.sizing.htype = 'Extent';
    param.text.sizing.wtype = 'Extent';
    
    param.status.sizing.htype = 'Extent';
    param.status.sizing.wtype = 'Fixed';
        %setup for edit width
        dum = uicontrol('Style','Text','String','This is a long status message');
        set(dum,param.status.style);
        dext = get(dum,'Extent');
        delete(dum);
    param.status.sizing.w = dext(3)+15;
    
    param.edit.sizing.htype = 'Fixed';
    param.edit.sizing.wtype = 'Fixed';
    
        %setup for edit height
        dum = uicontrol('Style','Text','String','20.00');
        set(dum,param.edit.style);
        dext = get(dum,'Extent');
        delete(dum);
    param.edit.sizing.h = dext(4)+2; % edit box height should be 2 pixels greater than text
    param.edit.sizing.w = dext(3)+15; % edit box should fit 4 digit number with decimal point
    
    param.popup.sizing.htype = 'Fixed';
    param.popup.sizing.wtype = 'ExtentPlus';
    param.popup.sizing.h = param.edit.sizing.h;
    param.popup.sizing.wplus = 25; % to account for popup arrow;
    
    param.button.sizing.htype = 'ExtentPlus';
    param.button.sizing.wtype = 'ExtentPlus';
    param.button.sizing.wplus = 5;
    param.button.sizing.hplus = 2;
    
    param.toggle.sizing.htype = 'ExtentPlus';
    param.toggle.sizing.wtype = 'ExtentPlus';
    param.toggle.sizing.hplus = 2;
    param.toggle.sizing.wplus = 5;
    
    param.checkbox.sizing.htype = 'Fixed';
    param.checkbox.sizing.wtype = 'Fixed';
    param.checkbox.sizing.h = 15;
    param.checkbox.sizing.w = 15;
    
    % Filename edit boxes should be bigger than number edit boxes
    param.filename.sizing.htype = 'Fixed';
    param.filename.sizing.wtype = 'Fixed';
    param.filename.sizing.h = param.edit.sizing.h; % same height as other edits
    param.filename.sizing.w = 2*param.edit.sizing.w; % double width
    
    % Spacing
    param.spacing.buf = 4; % horizontal pixel buffer spacing...
    param.spacing.min_line_spacing = 4; % this is the spacing above and beyond what is required
    param.spacing.checkboxlift = 6; % this is the amount checkboxes should be lifted to be centered on the line
        
otherwise
    delete(fig);
    error([stylesetting ' is an unknown style setting']);
end

delete(fig);